from db import get_db_connection

def get_riwayat_setor_nasabah(cabang):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("SELECT nik,cabang,jenis,satuan,jumlah,harga,total,tanggal FROM setor_nasabah WHERE cabang = %s", (cabang,))
    result = cursor.fetchall()
    conn.close()

    if result:
        return [
            {
                "nik": row[0],
                "cabang": row[1],
                "jenis": row[2],
                "satuan": row[3],
                "jumlah": row[4],
                "harga": row[5],
                "total": row[6],
                "tanggal": row[7]
            }
            for row in result
        ]
    else:
        return{"error": "Data tidak ditemukan"}
    
def get_riwayat_tarik_nasabah(cabang):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("SELECT nik,cabang,jumlah,tanggal FROM tarik_nasabah WHERE cabang = %s", (cabang,))
    result = cursor.fetchall()
    conn.close()

    if result:
        return [
            {
                "nik": row[0],
                "cabang": row[1],
                "jumlah": row[2],
                "tanggal": row[3]
            }
            for row in result
        ]
    else:
        return{"error": "Data tidak ditemukan"}
    
def get_riwayat_setor_cabang(cabang):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("SELECT cabang,jenis,satuan,jumlah,harga,total,tanggal FROM setor_admin WHERE cabang = %s", (cabang,))
    result = cursor.fetchall()
    conn.close()

    if result:
        return [
            {
                "cabang": row[0],
                "jenis": row[1],
                "satuan": row[2],
                "jumlah": row[3],
                "harga": row[4],
                "total": row[5],
                "tanggal": row[6]
            }
            for row in result
        ]
    else:
        return{"error": "Data tidak ditemukan"}

def setorsampahadmin(cabang, data):
    db = get_db_connection()
    cursor = db.cursor()
    total = 0

    try:
        # Insert data setor sampah
        for item in data:
            item["total"] = item["jumlah"] * item["harga"]
            total += item["total"]
            cursor.execute(
                "INSERT INTO setor_admin (cabang, jenis, satuan, jumlah, harga, total) VALUES (%s, %s, %s, %s, %s, %s)",
                (cabang, item["jenis"], item["satuan"], item["jumlah"], item["harga"], item["total"])
            )

        # Jika tidak ada data yang dimasukkan, rollback
        if len(data) == 0:
            db.rollback()
            return {"error": "Tidak ada data yang disetor!"}

        # Commit transaksi
        db.commit()
        return {"message": "Setor sampah berhasil!"}

    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}

    finally:
        cursor.close()
        db.close()

def getgrafiksetornasabah(cabang):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("SELECT jenis, SUM(jumlah) FROM setor_nasabah WHERE cabang = %s GROUP BY jenis", (cabang,))
    result = cursor.fetchall()
    conn.close()

    return [
        {"jenis": row[0], "jumlah": float(row[1])}
        for row in result
    ] if result else []  # Pastikan return selalu list

def getgrafiksetorcabang(cabang):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("SELECT jenis, SUM(jumlah) FROM setor_admin WHERE cabang = %s GROUP BY jenis", (cabang,))
    result = cursor.fetchall()
    conn.close()

    return [
        {"jenis": row[0], "jumlah": float(row[1])}
        for row in result
    ] if result else []  # Pastikan return selalu list