from db import get_db_connection
from utils import hash_password
import os

def getadmin(id):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT id, nama, alamat, no_hp, email, level, logo FROM admin WHERE id = %s", (id,))
    result = cursor.fetchone()
    db.close()

    if result:
        return {
            "id": result[0],
            "nama": result[1],
            "alamat": result[2],
            "no_hp": result[3],
            "email": result[4],
            "level": result[5],
            "logo": result[6],
        }
    else:
        return {"error": "Data Admin tidak ditemukan!"}
    
def getalladmin():
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT id, nama, alamat, no_hp, email, level FROM admin")
    result = cursor.fetchall()
    db.close()

    if result:
        return [
            {   
                "id": row[0],
                "nama": row[1],
                "alamat": row[2],
                "no_hp": row[3],
                "email": row[4],
                "level": row[5],
            }
            for row in result
        ]
    else:
        return {"error": "Data Admin Kosong!"}
    
def updateadmin(id_admin, nama, alamat, no_hp, email, level):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        # Ambil nama cabang lama sebelum update
        cursor.execute("SELECT nama FROM admin WHERE id = %s", (id_admin,))
        row = cursor.fetchone()
        if not row:
            return {"error": "Admin tidak ditemukan"}
        nama_lama = row[0]

        # Update data admin
        cursor.execute(
            "UPDATE admin SET nama = %s, alamat = %s, no_hp = %s, email = %s, level = %s WHERE id = %s",
            (nama, alamat, no_hp, email, level, id_admin)
        )

        # Update semua tabel terkait dengan nama cabang lama
        cursor.execute("UPDATE nasabah SET cabang = %s WHERE cabang = %s", (nama, nama_lama))
        cursor.execute("UPDATE setor_nasabah SET cabang = %s WHERE cabang = %s", (nama, nama_lama))
        cursor.execute("UPDATE tarik_nasabah SET cabang = %s WHERE cabang = %s", (nama, nama_lama))
        cursor.execute("UPDATE setor_admin SET cabang = %s WHERE cabang = %s", (nama, nama_lama))
        cursor.execute("UPDATE code_tarik SET cabang = %s WHERE cabang = %s", (nama, nama_lama))

        db.commit()

        return {"message": "Data Admin berhasil diubah!"}

    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}

    finally:
        cursor.close()
        db.close()


def updatepassword(id, password):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        hashed_password = hash_password(password)
        cursor.execute("UPDATE admin SET password = %s WHERE id = %s", (hashed_password, id))
        db.commit()

        if cursor.rowcount:
            return {"message": "Password berhasil diubah!"}
        else:
            return {"error": "Gagal mengubah password."}

    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}

    finally:
        cursor.close()
        db.close()

def deleteadmin(id):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        cursor.execute("SELECT logo FROM admin WHERE id = %s", (id,))
        result = cursor.fetchone()

        if not result:
            return {"error": "Data tidak ditemukan!"}

        file_path = result[0]

        cursor.execute("DELETE FROM admin WHERE id = %s", (id,))
        db.commit()

        if cursor.rowcount > 0:
            if os.path.exists(file_path):
                os.remove(file_path)
            return {"message": "Data Admin berhasil dihapus!"}
        else:
            return {"error": "Gagal menghapus data."}
        
    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}
    
    finally:
        cursor.close()
        db.close()

def getallnasabah():
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT nik, nama, no_hp, alamat, email, foto_ktp FROM nasabah")
    result = cursor.fetchall()
    db.close()

    if result:
        return [
            {
                "nik": row[0],
                "nama": row[1],
                "no_hp": row[2],
                "alamat": row[3],
                "email": row[4],
                "foto_ktp": row[5],
            }
            for row in result
        ]
    else:
        return {"error": "Data Nasabah Kosong!"}
    
def getnasabahbycabang(cabang):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT nik, nama, no_hp, alamat, email, foto_ktp, cabang FROM nasabah WHERE cabang = %s", (cabang,))
    result = cursor.fetchall()
    db.close()

    if result:
        return [
            {
                "nik": row[0],
                "nama": row[1],
                "no_hp": row[2],
                "alamat": row[3],
                "email": row[4],
                "foto_ktp": row[5],
                "cabang": row[6],
            }
            for row in result
        ]
    else:
        return {"error": "Data Nasabah Kosong!"}
    
def getnasabahdetail(nik):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT nik, nama, no_hp, alamat, email, foto_ktp FROM nasabah WHERE nik = %s", (nik,))
    result = cursor.fetchone()
    db.close()

    if result:
        return {
            "nik": result[0],
            "nama": result[1],
            "no_hp": result[2],
            "alamat": result[3],
            "email": result[4],
            "foto_ktp": result[5],
        }
    else:
        return {"error": "Data Nasabah tidak ditemukan!"}
    
def updatenasabah(nik, nama, no_hp, alamat, email):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        cursor.execute("UPDATE nasabah SET nama = %s, no_hp = %s, alamat = %s, email = %s WHERE nik = %s", (nama, no_hp, alamat, email, nik))
        db.commit()

        if cursor.rowcount:
            return {"message": "Data Nasabah berhasil diubah!"}
        else:
            return {"error": "Gagal mengubah data."}
        
    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}
    
    finally:
        cursor.close()
        db.close()

def updatepasswordnasabah(nik, password):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        hashed_password = hash_password(password)
        cursor.execute("UPDATE nasabah SET password = %s WHERE nik = %s", (hashed_password, nik))
        db.commit()

        if cursor.rowcount:
            return {"message": "Password berhasil diubah!"}
        else:
            return {"error": "Gagal mengubah password."}
        
    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}
    
    finally:
        cursor.close()
        db.close()

def updatefotoktp(nik, foto_ktp):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        cursor.execute("UPDATE nasabah SET foto_ktp = %s WHERE nik = %s", (foto_ktp, nik))
        db.commit()

        if cursor.rowcount:
            return {"message": "Foto KTP berhasil diubah!"}
        else:
            return {"error": "Gagal mengubah foto KTP."}
        
    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}
    
    finally:
        cursor.close()
        db.close()

def deletenasabah(nik):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        cursor.execute("SELECT foto_ktp FROM nasabah WHERE nik = %s", (nik,))
        result = cursor.fetchone()

        if not result:
            return {"error": "Data tidak ditemukan!"}
        
        file_path = result[0]

        cursor.execute("DELETE FROM nasabah WHERE nik = %s", (nik,))
        db.commit()

        if cursor.rowcount > 0:
            if os.path.exists(file_path):
                os.remove(file_path)
                return {"message": "Data nasabah dan file berhasil dihapus!"}
            else:
                return {"error": "File tidak ditemukan, tetapi data sudah dihapus dari database!"}
        else:
            return {"error": "Gagal menghapus data dari database."}
        
    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}
    
    finally:
        cursor.close()
        db.close()

def getallsampah():
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT id, jenis, satuan, harga_induk, harga_jual, gambar FROM sampah")
    result = cursor.fetchall()
    db.close()

    if result:
        return [
            {
                "id": row[0],
                "jenis": row[1],
                "satuan": row[2],
                "harga_induk": row[3],
                "harga_jual": row[4],
                "gambar": row[5],
            }
            for row in result
        ]
    else:
        return {"error": "Data Sampah Kosong!"}

def getsampahdetail(id):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT id, jenis, satuan, harga_induk, harga_jual, gambar FROM sampah WHERE id = %s", (id,))
    result = cursor.fetchone()
    db.close()

    if result:
        return {
            "id": result[0],
            "jenis": result[1],
            "satuan": result[2],
            "harga_induk": result[3],
            "harga_jual": result[4],
            "gambar": result[5],
        }
    else:
        return {"error": "Data Sampah tidak ditemukan!"}
    
def addsampah(jenis, satuan, harga_induk, harga_jual, gambar):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        cursor.execute("SELECT jenis FROM sampah WHERE jenis = %s", (jenis,))
        if cursor.fetchone():
            return {"error": "Jenis sampah sudah ada!"}
        
        cursor.execute("INSERT INTO sampah (jenis, satuan, harga_induk, harga_jual, gambar) VALUES (%s, %s, %s, %s, %s)", (jenis, satuan, harga_induk, harga_jual, gambar))
        db.commit()

        if cursor.lastrowid:
            return {"message": "Data Sampah berhasil ditambahkan!"}
        else:
            return {"error": "Gagal menambahkan data."}
        
    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}
    
    finally:
        cursor.close()
        db.close()
    
def updatesampah(id, jenis, satuan, harga_induk, harga_jual):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        # Ambil jenis sampah berdasarkan ID
        cursor.execute("SELECT jenis FROM sampah WHERE id = %s", (id,))
        jenis_sampah = cursor.fetchone()
        
        if not jenis_sampah:
            return {"error": "Sampah dengan ID tersebut tidak ditemukan!"}
        
        jenis_sampah = jenis_sampah[0]  # Ambil nilai string dari tuple

        # Jika jenis berbeda, cek apakah jenis baru sudah ada
        if jenis != jenis_sampah:
            cursor.execute("SELECT COUNT(*) FROM sampah WHERE jenis = %s AND id != %s", (jenis, id))
            if cursor.fetchone()[0] > 0:
                return {"error": "Jenis sampah sudah ada!"}

        # Update data sampah
        cursor.execute("""
            UPDATE sampah 
            SET jenis = %s, satuan = %s, harga_induk = %s, harga_jual = %s 
            WHERE id = %s
        """, (jenis, satuan, harga_induk, harga_jual, id))

        # Update juga di setor_admin dan setor_nasabah
        cursor.execute("UPDATE setor_admin SET jenis = %s, satuan = %s WHERE jenis = %s", (jenis, satuan, jenis_sampah))
        cursor.execute("UPDATE setor_nasabah SET jenis = %s, satuan = %s WHERE jenis = %s", (jenis, satuan, jenis_sampah))

        db.commit()

        # Cek apakah ada baris yang diubah
        if cursor.rowcount > 0:
            return {"message": "Data Sampah berhasil diubah!"}
        else:
            return {"message": "Tidak ada perubahan yang dilakukan."}

    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}
    
    finally:
        cursor.close()
        db.close()


def deletesampah(id):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        # Cek apakah data ada
        cursor.execute("SELECT gambar FROM sampah WHERE id = %s", (id,))
        result = cursor.fetchone()

        if not result:
            return {"error": "Data tidak ditemukan!"}

        file_path = result[0]

        # Hapus data dari database
        cursor.execute("DELETE FROM sampah WHERE id = %s", (id,))
        db.commit()

        if cursor.rowcount > 0:
            # Hapus file setelah commit berhasil
            if os.path.exists(file_path):
                os.remove(file_path)
                return {"message": "Data sampah dan file berhasil dihapus!"}
            else:
                return {"error": "File tidak ditemukan, tetapi data sudah dihapus dari database!"}
        else:
            return {"error": "Gagal menghapus data dari database."}

    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}

    finally:
        cursor.close()
        db.close()

def tariksaldo(code,cabang):
    db = get_db_connection()
    cursor = db.cursor()

    try:
        data = getcode(code,cabang)
        if "error" in data or not data:
            return {"error": data["error"] if "error" in data else "Data Code tidak ditemukan!"}
        
        # 1️⃣ Cek apakah nasabah ada & saldo mencukupi
        cursor.execute("SELECT aset FROM nasabah WHERE nik = %s", (data["nik"],))
        result = cursor.fetchone()
        
        if not result:
            return {"error": "Nasabah tidak ditemukan!"}

        saldo = result[0]
        
        if saldo < data["jumlah"]:
            return {"error": "Saldo tidak mencukupi!"}

        # 2️⃣ Proses penarikan saldo
        cursor.execute(
            "INSERT INTO tarik_nasabah (nik, cabang, jumlah) VALUES (%s, %s, %s)", 
            (data["nik"], data["cabang"], data["jumlah"])
        )
        cursor.execute(
            "UPDATE nasabah SET aset = aset - %s WHERE nik = %s", 
            (data["jumlah"], data["nik"])
        )
        cursor.execute(
            "DELETE FROM code_tarik WHERE code = %s",
            (code,)
        )

        db.commit()

        return {"message": "Penarikan saldo berhasil!"}

    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}
    
    finally:
        cursor.close()
        db.close()


def getcode(code,cabang):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT code, cabang, jumlah, tanggal_expired, nik FROM code_tarik WHERE code = %s AND cabang = %s", (code,cabang))
    result = cursor.fetchone()
    db.close()

    if result:
        return {
            "code": result[0],
            "cabang": result[1],
            "jumlah": int(result[2]),
            "tanggal_expired": result[3],
            "nik": result[4],
        }
    else:
        return {"error": "Data Code tidak ditemukan!"}

def setorsampahnasabah(nik, cabang, data):
    db = get_db_connection()
    cursor = db.cursor()
    total = 0

    try:
        # Cek apakah nasabah ada
        cursor.execute("SELECT aset FROM nasabah WHERE nik = %s", (nik,))
        result = cursor.fetchone()
        if not result:
            return {"error": "Nasabah tidak ditemukan!"}
        
        saldo = result[0]

        # Insert data setor sampah
        for item in data:
            item["total"] = item["jumlah"] * item["harga"]
            total += item["total"]
            cursor.execute(
                "INSERT INTO setor_nasabah (nik, cabang, jenis, satuan, jumlah, harga, total) VALUES (%s, %s, %s, %s, %s, %s, %s)",
                (nik, cabang, item["jenis"], item["satuan"], item["jumlah"], item["harga"], item["total"])
            )

        # Jika tidak ada data yang dimasukkan, rollback
        if len(data) == 0:
            db.rollback()
            return {"error": "Tidak ada data yang disetor!"}

        # Update saldo nasabah setelah semua transaksi berhasil
        cursor.execute("UPDATE nasabah SET aset = %s WHERE nik = %s", (saldo + total, nik))
        
        # Commit transaksi
        db.commit()
        return {"message": "Setor sampah berhasil!"}

    except Exception as e:
        db.rollback()
        return {"error": f"Terjadi kesalahan: {str(e)}"}

    finally:
        cursor.close()
        db.close()

def getallsetornasabah():
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT id, nik, cabang, jenis, satuan, jumlah, harga, total, tanggal FROM setor_nasabah")
    result = cursor.fetchall()
    db.close()

    if result:
        return [
            {
                "id": row[0],
                "nik": row[1],
                "cabang": row[2],
                "jenis": row[3],
                "satuan": row[4],
                "jumlah": row[5],
                "harga": row[6],
                "total": row[7],
                "tanggal": row[8],
            }
            for row in result
        ]
    else:
        return {"error": "Data Setor Kosong!"}

def getalltariknasabah():
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT id, nik, cabang, jumlah, tanggal FROM tarik_nasabah")
    result = cursor.fetchall()
    db.close()

    if result:
        return [
            {
                "id": row[0],
                "nik": row[1],
                "cabang": row[2],
                "jumlah": row[3],
                "tanggal": row[4],
            }
            for row in result
        ]
    else:
        return {"error": "Data Tarik Kosong!"}

def getgrafiksetor():
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT cabang, SUM(jumlah) AS jumlah FROM setor_admin GROUP BY cabang")
    result = cursor.fetchall()
    db.close()

    if result:
        return [
            {
                "cabang": row[0],
                "jumlah": float(row[1]),
            }
            for row in result
        ]
    else:
        return []   

def getadminaset(cabang):
    db = get_db_connection()
    
    with db.cursor(dictionary=True) as cursor:
        cursor.execute(
            """
            SELECT 
    n.jenis, 
    COALESCE(SUM(n.jumlah), 0) - COALESCE((
        SELECT SUM(a.jumlah) 
        FROM setor_admin a 
        WHERE a.jenis = n.jenis AND a.cabang = n.cabang
    ), 0) AS jumlah, 
    n.satuan
FROM setor_nasabah n
WHERE n.cabang = %s
GROUP BY n.jenis
            """,
            (cabang,)
        )
        result = cursor.fetchall()
    
    db.close()
    
    # Jika data kosong, tetap kembalikan list kosong
    if not result:
        return []  # List kosong, bukan dictionary

    return [
        {
            "jenis": row["jenis"],
            "jumlah": row["jumlah"],
            "satuan": row["satuan"],
        }
        for row in result
    ]


def getallsetoradmin():
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT cabang, jenis, satuan, jumlah, harga, total, tanggal FROM setor_admin")
    result = cursor.fetchall()
    db.close()

    if result:
        return [
            {
                "cabang": row[0],
                "jenis": row[1],
                "satuan": row[2],
                "jumlah": row[3],
                "harga": row[4],
                "total": row[5],
                "tanggal": row[6],
            }
            for row in result
        ]
    else:
        return {"error": "Data Setor Kosong!"}