import jwt
import datetime
import os
from dotenv import load_dotenv

load_dotenv()

SECRET_KEY = os.getenv("SECRET_KEY_JWT")
if not SECRET_KEY:
    raise ValueError("SECRET_KEY_JWT tidak boleh kosong!")

def generate_jwt(user_id, nama, level):
    """Membuat token JWT berlaku 1 hari."""
    payload = {
        "id": user_id,
        "nama": nama,
        "level": level,
        "exp": datetime.datetime.utcnow() + datetime.timedelta(days=1)
    }
    return jwt.encode(payload, SECRET_KEY, algorithm="HS256")

def verify_jwt(token):
    """Verifikasi token JWT dengan pengecekan error yang lebih spesifik."""
    try:
        decoded = jwt.decode(token, SECRET_KEY, algorithms=["HS256"])
        return decoded
    except jwt.ExpiredSignatureError:
        return {"error": "Token expired"}
    except jwt.InvalidTokenError:
        return {"error": "Token invalid"}
